/*  Datawarehouse - Tabellen

    Diese Tabellen werden durch die TLog.Datawarehouse_%-Funktionen befüllt. Sie enthalten die Zustände vordefinierter Spalten
    zu vorgegebenen Zeitpunkten. */

-- ************************** Zeitliche Kopie relevanter Werte des Artikelstamms **************************
DROP TABLE IF EXISTS tlog.datawarehouse_art;
CREATE TABLE tlog.datawarehouse_art
  (
    snapshot_date         date NOT NULL,
    --
    ak_nr                 varchar NOT NULL,     -- Artikelnummer
    --
    ak_standard_mgc       smallint,             -- Mengeneinheit (Standard)
    ak_hest               numeric,              -- Selbstkosten (reine Herstellkosten)
    ak_fertk              numeric,              -- Montagekosten
    ak_rust               numeric,              -- Rüstkosten
    ak_matk               numeric,              -- Materialkosten
    ak_awkost             numeric,              -- Auswärtskosten
    --
    ak_los                numeric,              -- Losgröße
    ak_vkpbas             numeric,              -- Verkaufspreis
    ak_vkpfaktor          numeric,              -- Verkaufspreisfaktor
    ak_vkprund            numeric,              -- Rundungsgenauigkeit
    ak_vkpbasfix          numeric,              -- Festpreis
    --
    ak_tot                numeric,              -- Lagernd, total
    ak_res                numeric,              -- Verkauft, reserviert
    ak_bes                numeric,              -- Bestellt, eingekauft
    ak_verfueg            numeric,              -- verfügbare Menge: Lagernd + Bestellt - Verkauft - Mindestbestand
    --
    ak_ks                 varchar,              -- Kostenstelle
    --
    UNIQUE ( snapshot_date, ak_nr)
  );

  CREATE INDEX datawarehouse_art__ak_nr ON tlog.datawarehouse_art (ak_nr);

--

-- ************************** Zeitliche Kopie relevanter Werte zum Verkauf **************************
DROP TABLE IF EXISTS tlog.datawarehouse_auftg;
CREATE TABLE tlog.datawarehouse_auftg
  (
    snapshot_date         date NOT NULL,
    --
    --  TODO: on DELETE?
    p_id                  integer NOT NULL,               -- AuftragsID
    p_code                varchar,
    p_nummer              varchar,
    p_pos                 integer,
    --
    p_aknr                varchar,                        -- Artikelnummer
    --
    p_menge_gme           numeric,                        -- Menge in GME
    p_mengeb_gme          numeric,                        -- Menge bestellt in GME
    p_mengel_gme          numeric,                        -- Menge geliefert in GME
    p_mengef_gme          numeric,                        -- Menge fakturiert in GME
    --
    p_ks                  varchar,                        -- Zugeordnete Kostenstelle
    --
    p_preis_me            numeric,                        -- Preis pro ME
    p_preis_gwaer         numeric,                        -- Preis pro ME in Grundwährung
    p_waer                varchar,                        -- Pos. Währungseinheit
    p_kurs                numeric,                        -- Pos. Kurs zur Basiswährung
    p_scode               integer,                        -- Steuercode
    p_sproz               numeric,                        -- Steuerprozentsatz
    p_rabatt              numeric,                        -- Rabattsatz (0...100)
    p_CanRabatt           boolean,                        -- Kennzeichen Rabattfähig
    --
    p_wert_ep_netto       numeric,                        -- Einzelpreis ohne Abzuschläge inkl. Rabatte
    p_wert_netto          numeric,                        -- Positionswert inkl. AbZuschläge
    p_wert_netto_gwaer    numeric,                        -- Positionswert inkl. AbZuschläge in Basiswährung    
    p_IsUmsatz            boolean,                        -- Kennzeichen umsatzwirksame Position
    --
    p_datum_eingang       date,                           -- Eingangsdatum
    p_datum_erfasst       date,                           -- Erfassdatum
    p_datum_soll          date,                           -- Wunschdatum
    p_datum_ist           date,                           -- Bestätigtes Datum
    p_done                boolean,                        -- Kennzeichen Pos. Erledigt
    p_storniert           boolean,                        -- Kennzeichen Pos. Storniert
    p_datum_storniert     date,                           -- Datum an dem die Pos. Storniert wurde
    --
    p_adkrz               varchar,                        -- Adresskürzel (Kunde o. Lieferant)
    p_adkrzl              varchar,                        -- Adresskürzel Lieferadresse
    p_adkrzf              varchar,                        -- Adresskürzel Rechnungsadresse
    --
    UNIQUE ( snapshot_date, p_id)
  );

  CREATE INDEX datawarehouse_auftg__p_id ON tlog.datawarehouse_auftg (p_id);
--

-- ************************** Zeitliche Kopie relevanter Werte zum Lager **************************
DROP TABLE IF EXISTS tlog.datawarehouse_lag;
CREATE TABLE tlog.datawarehouse_lag
  (
    snapshot_date         date NOT NULL,
    --
    lg_id                 integer NOT NULL,
    --
    lg_aknr               varchar,                        -- Artikelnummer
    lg_ort                varchar,                        -- Lagerort
    lg_anztot             numeric,                        -- Bestand am Lagerort
    lg_chnr               varchar,                        -- Chargennummer
    lg_sperr              boolean,                        -- Sperrkennzeichen
    lgo_verfgbar          boolean,                        -- Lagerort geht in Verfügbarkeit ein
    lgo_werthg            boolean,                        -- Lagerort ist werthaltig
    lgo_beistell          boolean,                        -- Lagerort ist für Beistellmaterial
    --
    UNIQUE ( snapshot_date, lg_id, lg_aknr)
  );

  CREATE INDEX datawarehouse_lag__ak_nr ON tlog.datawarehouse_lag (lg_aknr);
--